// Questions data
const questions = [
  {
    text: "Lorem ipsum dolor sit amet consectetur. Adipiscing tempor volutpat fringilla consequat enim sagittis aliquam. Elit nibh dignissim ut neque blandit pharetra molestie. Cursus neque turpis facilisis id lectus aliquet consequat eu fringilla. Tempor augue mi sapien tristique nibh sed euismod elementum.?",
    answers: [
      "Lorem ipsum dolor sit amet consectetur. Adipiscing tempor volutpat",
      "Lorem ipsum dolor sit amet consectetur. Adipiscing tempor volutpat",
      "Lorem ipsum dolor sit amet consectetur. Adipiscing tempor volutpat",
      "Lorem ipsum dolor sit amet consectetur. Adipiscing tempor volutpat",
    ],
  },
  {
    text: "Lorem ipsum dolor sit amet consectetur. Adipiscing tempor volutpat fringilla consequat enim sagittis aliquam. Elit nibh dignissim ut neque blandit pharetra molestie. Cursus neque turpis facilisis id lectus aliquet consequat eu fringilla. Tempor augue mi sapien tristique nibh sed euismod elementum.?",
    answers: [
      "Lorem ipsum dolor sit amet consectetur. Adipiscing tempor volutpat",
      "Lorem ipsum dolor sit amet consectetur. Adipiscing tempor volutpat",
      "Lorem ipsum dolor sit amet consectetur. Adipiscing tempor volutpat",
      "Lorem ipsum dolor sit amet consectetur. Adipiscing tempor volutpat",
    ],
  },
  {
    text: "Lorem ipsum dolor sit amet consectetur. Adipiscing tempor volutpat fringilla consequat enim sagittis aliquam. Elit nibh dignissim ut neque blandit pharetra molestie. Cursus neque turpis facilisis id lectus aliquet consequat eu fringilla. Tempor augue mi sapien tristique nibh sed euismod elementum.?",
    answers: [
      "Lorem ipsum dolor sit amet consectetur. Adipiscing tempor volutpat",
      "Lorem ipsum dolor sit amet consectetur. Adipiscing tempor volutpat",
      "Lorem ipsum dolor sit amet consectetur. Adipiscing tempor volutpat",
      "Lorem ipsum dolor sit amet consectetur. Adipiscing tempor volutpat",
    ],
  },
  {
    text: "Lorem ipsum dolor sit amet consectetur. Adipiscing tempor volutpat fringilla consequat enim sagittis aliquam. Elit nibh dignissim ut neque blandit pharetra molestie. Cursus neque turpis facilisis id lectus aliquet consequat eu fringilla. Tempor augue mi sapien tristique nibh sed euismod elementum.?",
    answers: [
      "Lorem ipsum dolor sit amet consectetur. Adipiscing tempor volutpat",
      "Lorem ipsum dolor sit amet consectetur. Adipiscing tempor volutpat",
      "Lorem ipsum dolor sit amet consectetur. Adipiscing tempor volutpat",
      "Lorem ipsum dolor sit amet consectetur. Adipiscing tempor volutpat",
    ],
  },
  {
    text: "Lorem ipsum dolor sit amet consectetur. Adipiscing tempor volutpat fringilla consequat enim sagittis aliquam. Elit nibh dignissim ut neque blandit pharetra molestie. Cursus neque turpis facilisis id lectus aliquet consequat eu fringilla. Tempor augue mi sapien tristique nibh sed euismod elementum.?",
    answers: [
      "Lorem ipsum dolor sit amet consectetur. Adipiscing tempor volutpat",
      "Lorem ipsum dolor sit amet consectetur. Adipiscing tempor volutpat",
      "Lorem ipsum dolor sit amet consectetur. Adipiscing tempor volutpat",
      "Lorem ipsum dolor sit amet consectetur. Adipiscing tempor volutpat",
    ],
  },
  {
    text: "Lorem ipsum dolor sit amet consectetur. Adipiscing tempor volutpat fringilla consequat enim sagittis aliquam. Elit nibh dignissim ut neque blandit pharetra molestie. Cursus neque turpis facilisis id lectus aliquet consequat eu fringilla. Tempor augue mi sapien tristique nibh sed euismod elementum.?",
    answers: [
      "Lorem ipsum dolor sit amet consectetur. Adipiscing tempor volutpat",
      "Lorem ipsum dolor sit amet consectetur. Adipiscing tempor volutpat",
      "Lorem ipsum dolor sit amet consectetur. Adipiscing tempor volutpat",
      "Lorem ipsum dolor sit amet consectetur. Adipiscing tempor volutpat",
    ],
  },
  {
    text: "Lorem ipsum dolor sit amet consectetur. Adipiscing tempor volutpat fringilla consequat enim sagittis aliquam. Elit nibh dignissim ut neque blandit pharetra molestie. Cursus neque turpis facilisis id lectus aliquet consequat eu fringilla. Tempor augue mi sapien tristique nibh sed euismod elementum.?",
    answers: [
      "Lorem ipsum dolor sit amet consectetur. Adipiscing tempor volutpat",
      "Lorem ipsum dolor sit amet consectetur. Adipiscing tempor volutpat",
      "Lorem ipsum dolor sit amet consectetur. Adipiscing tempor volutpat",
      "Lorem ipsum dolor sit amet consectetur. Adipiscing tempor volutpat",
    ],
  },
  {
    text: "Lorem ipsum dolor sit amet consectetur. Adipiscing tempor volutpat fringilla consequat enim sagittis aliquam. Elit nibh dignissim ut neque blandit pharetra molestie. Cursus neque turpis facilisis id lectus aliquet consequat eu fringilla. Tempor augue mi sapien tristique nibh sed euismod elementum.?",
    answers: [
      "Lorem ipsum dolor sit amet consectetur. Adipiscing tempor volutpat",
      "Lorem ipsum dolor sit amet consectetur. Adipiscing tempor volutpat",
      "Lorem ipsum dolor sit amet consectetur. Adipiscing tempor volutpat",
      "Lorem ipsum dolor sit amet consectetur. Adipiscing tempor volutpat",
    ],
  },
  {
    text: "Lorem ipsum dolor sit amet consectetur. Adipiscing tempor volutpat fringilla consequat enim sagittis aliquam. Elit nibh dignissim ut neque blandit pharetra molestie. Cursus neque turpis facilisis id lectus aliquet consequat eu fringilla. Tempor augue mi sapien tristique nibh sed euismod elementum.?",
    answers: [
      "Lorem ipsum dolor sit amet consectetur. Adipiscing tempor volutpat",
      "Lorem ipsum dolor sit amet consectetur. Adipiscing tempor volutpat",
      "Lorem ipsum dolor sit amet consectetur. Adipiscing tempor volutpat",
      "Lorem ipsum dolor sit amet consectetur. Adipiscing tempor volutpat",
    ],
  },
  {
    text: "Lorem ipsum dolor sit amet consectetur. Adipiscing tempor volutpat fringilla consequat enim sagittis aliquam. Elit nibh dignissim ut neque blandit pharetra molestie. Cursus neque turpis facilisis id lectus aliquet consequat eu fringilla. Tempor augue mi sapien tristique nibh sed euismod elementum.?",
    answers: [
      "Lorem ipsum dolor sit amet consectetur. Adipiscing tempor volutpat",
      "Lorem ipsum dolor sit amet consectetur. Adipiscing tempor volutpat",
      "Lorem ipsum dolor sit amet consectetur. Adipiscing tempor volutpat",
      "Lorem ipsum dolor sit amet consectetur. Adipiscing tempor volutpat",
    ],
  },
];

// Initialize variables
let currentQuestion = 0;
let userAnswers = Array(questions.length).fill(null);
const progressBar = document.getElementById("progress-bar");
const progressPercent = document.getElementById("progress-percent");
const currentQuestionElement = document.getElementById("current-question");
const questionText = document.getElementById("question-text");
const answersList = document.getElementById("answers-list");
const prevBtn = document.getElementById("prev-btn");
const nextBtn = document.getElementById("next-btn");
const questionListItems = document.getElementById("question-list-items");
const timerElement = document.getElementById("timer");
const assessmentPage = document.getElementById("assessment-page");
const thankYouPage = document.getElementById("thank-you-page");
const restartBtn = document.getElementById("restart-btn");

// Timer variables
let timeLeft = 30 * 60; // 30 minutes in seconds
let timerInterval;

// Initialize timer
function startTimer() {
  updateTimerDisplay();

  timerInterval = setInterval(() => {
    timeLeft--;
    updateTimerDisplay();

    if (timeLeft <= 0) {
      clearInterval(timerInterval);
      handleTimeUp();
    } else if (timeLeft <= 300) {
      // 5 minutes left
      timerElement.classList.add("time-warning");
    }
  }, 1000);
}

// Update timer display
function updateTimerDisplay() {
  const minutes = Math.floor(timeLeft / 60);
  const seconds = timeLeft % 60;
  timerElement.textContent = `${minutes.toString().padStart(2, "0")}:${seconds
    .toString()
    .padStart(2, "0")}`;
}

// Handle when time is up
function handleTimeUp() {
  alert("Time's up! The assessment will now be submitted.");
  showThankYouPage();
}

// Show thank you page
function showThankYouPage() {
  clearInterval(timerInterval);

  // Switch to thank you page
  assessmentPage.style.display = "none";
  thankYouPage.style.display = "block";
}

// Initialize question list
function initializeQuestionList() {
  questions.forEach((_, index) => {
    const questionItem = document.createElement("div");
    questionItem.className = `question-list-item ${
      index === 0 ? "current" : "unanswered"
    }`;

    // Add icon only for the first question
    if (index === 0) {
      const icon = document.createElement("i");
      icon.className = "fas fa-check-circle question-list-icon";
      questionItem.appendChild(icon);
    } else {
      const emptySpace = document.createElement("span");
      emptySpace.className = "question-list-icon";
      emptySpace.innerHTML = "&nbsp;&nbsp;&nbsp;"; // Creates space for alignment
      questionItem.appendChild(emptySpace);
    }

    const questionText = document.createElement("span");
    questionText.textContent = `Question ${index + 1}`;
    questionItem.appendChild(questionText);

    questionItem.addEventListener("click", () => navigateToQuestion(index));
    questionListItems.appendChild(questionItem);
  });
}

// Update progress
function updateProgress() {
  const answeredCount = userAnswers.filter((answer) => answer !== null).length;
  const progress = (answeredCount / questions.length) * 100;
  progressBar.style.width = `${progress}%`;
  progressPercent.textContent = `${Math.round(progress)}%`;
}

// Display current question
function displayQuestion() {
  const question = questions[currentQuestion];
  questionText.textContent = question.text;
  currentQuestionElement.textContent = currentQuestion + 1;

  // Clear previous answers
  answersList.innerHTML = "";

  // Add new answers
  question.answers.forEach((answer, index) => {
    const answerItem = document.createElement("div");
    answerItem.className = `answer-item ${
      userAnswers[currentQuestion] === index ? "selected" : ""
    }`;
    answerItem.setAttribute("data-value", index);

    const icon = document.createElement("i");
    icon.className = "fas fa-check-circle answer-icon";

    const answerText = document.createElement("span");
    answerText.textContent = answer;

    answerItem.appendChild(icon);
    answerItem.appendChild(answerText);

    answerItem.addEventListener("click", () => selectAnswer(index));
    answersList.appendChild(answerItem);
  });

  // Update navigation buttons
  prevBtn.disabled = currentQuestion === 0;
  nextBtn.textContent =
    currentQuestion === questions.length - 1 ? "Finish" : "Next";

  // Update question list
  updateQuestionList();
  updateProgress();
}

// Select answer
function selectAnswer(answerIndex) {
  userAnswers[currentQuestion] = answerIndex;
  displayQuestion();
}

// Update question list
function updateQuestionList() {
  const questionItems = document.querySelectorAll(".question-list-item");
  questionItems.forEach((item, index) => {
    // Reset classes
    item.className = "question-list-item";

    // Update icon based on current question
    const icon = item.querySelector(".question-list-icon");
    if (icon) {
      if (index === currentQuestion) {
        icon.className = "fas fa-arrow-right question-list-icon";
      } else if (userAnswers[index] !== null) {
        icon.className = "fas fa-check-circle question-list-icon";
      } else {
        icon.className = "fas fa-circle question-list-icon";
      }
    }

    // Update background color
    if (userAnswers[index] !== null) {
      item.classList.add("answered");
    } else {
      item.classList.add("unanswered");
    }

    if (index === currentQuestion) {
      item.classList.add("current");
    }
  });
}

// Navigate to question
function navigateToQuestion(questionIndex) {
  currentQuestion = questionIndex;
  displayQuestion();
}

// Restart assessment
function restartAssessment() {
  currentQuestion = 0;
  userAnswers = Array(questions.length).fill(null);
  timeLeft = 30 * 60;

  // Reset UI
  updateProgress();
  displayQuestion();

  // Switch back to assessment page
  assessmentPage.style.display = "block";
  thankYouPage.style.display = "none";

  // Restart timer
  clearInterval(timerInterval);
  timerElement.classList.remove("time-warning");
  startTimer();
}

// Event listeners for navigation
prevBtn.addEventListener("click", () => {
  if (currentQuestion > 0) {
    currentQuestion--;
    displayQuestion();
  }
});

nextBtn.addEventListener("click", () => {
  if (currentQuestion < questions.length - 1) {
    currentQuestion++;
    displayQuestion();
  } else {
    // Finish assessment
    showThankYouPage();
  }
});

// Event listeners for thank you page buttons
restartBtn.addEventListener("click", restartAssessment);

// Initialize the assessment
initializeQuestionList();
displayQuestion();
startTimer();
