document.addEventListener("DOMContentLoaded", function () {
  const select = document.getElementById("maritalStatus");
  const selectWrapper = document.querySelector(".select-wrapper");
  const label = document.querySelector("label");

  select.addEventListener("focus", function () {
    selectWrapper.classList.add("active");
    select.classList.add("active");
  });

  select.addEventListener("blur", function () {
    selectWrapper.classList.remove("active");
    if (select.value === "") {
      select.classList.remove("active");
    }
  });

  // Also handle change event to ensure label stays up when value is selected
  select.addEventListener("change", function () {
    if (select.value !== "") {
      select.classList.add("active");
    }
  });
});
