document.addEventListener("DOMContentLoaded", function () {
  const lightIcon = document.getElementById("light-icon");
  const darkIcon = document.getElementById("dark-icon");
  const body = document.body;

  // Check for saved user preference, if any, on load
  const currentTheme = localStorage.getItem("theme") || "light";
  if (currentTheme === "dark") {
    enableDarkMode();
  }

  // Listen for icon clicks
  lightIcon.addEventListener("click", enableDarkMode);
  darkIcon.addEventListener("click", enableLightMode);

  function enableDarkMode() {
    body.classList.add("dark-mode");
    lightIcon.classList.add("hidden");
    darkIcon.classList.remove("hidden");
    lightIcon.classList.remove("active");
    darkIcon.classList.add("active");
    localStorage.setItem("theme", "dark");
  }

  function enableLightMode() {
    body.classList.remove("dark-mode");
    darkIcon.classList.add("hidden");
    lightIcon.classList.remove("hidden");
    darkIcon.classList.remove("active");
    lightIcon.classList.add("active");
    localStorage.setItem("theme", "light");
  }
});
