document.addEventListener("DOMContentLoaded", function () {
  const carouselItems = document.querySelectorAll(".carousel-item");
  const indicators = document.querySelectorAll(".indicator");
  const prevButton = document.querySelector(".carousel-prev");
  const nextButton = document.querySelector(".carousel-next");
  let currentSlide = 0;
  let slideInterval;

  // Function to show a specific slide
  function showSlide(index) {
    // Hide all slides
    carouselItems.forEach((item) => item.classList.remove("active"));
    indicators.forEach((indicator) => indicator.classList.remove("active"));

    // Show the selected slide
    carouselItems[index].classList.add("active");
    indicators[index].classList.add("active");

    currentSlide = index;
  }

  // Function to go to next slide
  function nextSlide() {
    let nextIndex = (currentSlide + 1) % carouselItems.length;
    showSlide(nextIndex);
  }

  // Function to go to previous slide
  function prevSlide() {
    let prevIndex =
      (currentSlide - 1 + carouselItems.length) % carouselItems.length;
    showSlide(prevIndex);
  }

  // Add event listeners to indicators
  indicators.forEach((indicator, index) => {
    indicator.addEventListener("click", () => {
      showSlide(index);
      resetInterval();
    });
  });

  // Add event listeners to navigation buttons
  prevButton.addEventListener("click", () => {
    prevSlide();
    resetInterval();
  });

  nextButton.addEventListener("click", () => {
    nextSlide();
    resetInterval();
  });

  // Auto-advance slides (optional)
  function startInterval() {
    slideInterval = setInterval(nextSlide, 3000);
  }

  function resetInterval() {
    clearInterval(slideInterval);
    startInterval();
  }

  // Start the auto-advance
  startInterval();

  // Pause on hover
  const carousel = document.querySelector(".carousel");
  carousel.addEventListener("mouseenter", () => {
    clearInterval(slideInterval);
  });

  carousel.addEventListener("mouseleave", () => {
    startInterval();
  });

  // Keyboard navigation
  document.addEventListener("keydown", (e) => {
    if (e.key === "ArrowLeft") {
      prevSlide();
      resetInterval();
    } else if (e.key === "ArrowRight") {
      nextSlide();
      resetInterval();
    }
  });
});
