// Title configurations
const sections = [
  { id: "personal_information-page1", title: "Personal Information | KlinHR" },
  {
    id: "personal_information-page2",
    title: "Educational Qualification(s) | KlinHR",
  },
  {
    id: "personal_information-page3",
    title: "Professional Experience | KlinHR",
  },
  { id: "personal_information-page4", title: "Other Information | KlinHR" },
];

const defaultTitle = "Application Details | KlinHR";

// Throttle function to limit scroll events
function throttle(func, limit) {
  let inThrottle;
  return function () {
    const args = arguments;
    const context = this;
    if (!inThrottle) {
      func.apply(context, args);
      inThrottle = true;
      setTimeout(() => (inThrottle = false), limit);
    }
  };
}

function updateTitleOnScroll() {
  const scrollPosition = window.scrollY + window.innerHeight / 3;

  let currentSection = null;

  sections.forEach((section) => {
    const element = document.getElementById(section.id);
    if (element) {
      const position = element.offsetTop;
      const height = element.offsetHeight;

      if (scrollPosition >= position && scrollPosition < position + height) {
        currentSection = section;
      }
    }
  });

  document.title = currentSection ? currentSection.title : defaultTitle;
}

// Add scroll listener with throttling
window.addEventListener("scroll", throttle(updateTitleOnScroll, 10));
