document.addEventListener("DOMContentLoaded", function () {
  const pageNumbers = document.querySelectorAll(".number");
  const prevArrow = document.getElementById("prev-arrow");
  const nextArrow = document.getElementById("next-arrow");
  const currentPageElement = document.getElementById("current-page");
  const pageContentElement = document.getElementById("page-content");

  let currentPage = 1;
  const totalPages = 4;

  // Page content data
  const pageContents = {
    1: "This is the content for page 1. Navigate using the arrows or click on page numbers.",
    2: "Welcome to page 2! Here you'll find different information than on the previous page.",
    3: "You've reached page 3. Notice how the active page indicator changes as you navigate.",
    4: "This is the final page. Try going back to previous pages using the navigation controls.",
  };

  // Function to update active page
  function updateActivePage(page) {
    // Remove active class from all numbers
    pageNumbers.forEach((num) => num.classList.remove("active"));

    // Add active class to current page
    document
      .querySelector(`.number[data-page="${page}"]`)
      .classList.add("active");

    // Update current page display
    currentPageElement.textContent = page;

    // Update page content
    pageContentElement.textContent = pageContents[page];

    // Update current page variable
    currentPage = page;
  }

  // Add click event to page numbers
  pageNumbers.forEach((number) => {
    number.addEventListener("click", function () {
      const page = parseInt(this.getAttribute("data-page"));
      updateActivePage(page);
    });
  });

  // Previous arrow click
  prevArrow.addEventListener("click", function () {
    if (currentPage > 1) {
      updateActivePage(currentPage - 1);
    }
  });

  // Next arrow click
  nextArrow.addEventListener("click", function () {
    if (currentPage < totalPages) {
      updateActivePage(currentPage + 1);
    }
  });
});
