document.addEventListener("DOMContentLoaded", function () {
  const statusButton = document.getElementById("statusButton");
  const btnText = statusButton.querySelector(".btn-text");
  const postedContent = document.getElementById("postedContent");
  const expiredContent = document.getElementById("expiredContent");

  statusButton.addEventListener("click", function () {
    if (btnText.textContent === "Job Posted") {
      // Change to Job Expired state
      btnText.textContent = "Job Expired";
      statusButton.classList.remove("status-posted");
      statusButton.classList.add("status-expired");

      // Hide posted content, show expired content
      postedContent.style.display = "none";
      expiredContent.style.display = "block";
    } else {
      // Change back to Job Posted state
      btnText.textContent = "Job Posted";
      statusButton.classList.remove("status-expired");
      statusButton.classList.add("status-posted");

      // Hide expired content, show posted content
      postedContent.style.display = "block";
      expiredContent.style.display = "none";
    }
  });
});
