document.addEventListener("DOMContentLoaded", function () {
  const checkboxes = document.querySelectorAll('input[type="checkbox"]');
  const selectedCount = document.getElementById("selected-count");

  function updateSelectedCount() {
    const checkedCount = document.querySelectorAll(
      'input[type="checkbox"]:checked'
    ).length;
    selectedCount.textContent = checkedCount;
  }

  checkboxes.forEach((checkbox) => {
    checkbox.addEventListener("change", function () {
      const row = this.closest("tr");
      if (this.checked) {
        row.classList.add("checked");
      } else {
        row.classList.remove("checked");
      }
      updateSelectedCount();
    });
  });

  // Initialize selected count
  updateSelectedCount();
});
